function AISMN_BanditAttackUntilNearDead::OnEnter(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "attack");
   StartEffect(%object, "combat");
   
	%target = %object.banditTarget;
	if (isObject(%target) == false)
	{
	   SetStateVariable(%data, 0, 1.0);
	   return;
	}
	
	// face the target
   FaceObject(%data, %target);	
   StartAttackLoop(%object, %target);
   
   //Mount a weapon on the person.
   //Get the combat component
   %component = slgQueryInterface(%object, $CID_COMBAT);
   if (isObject(%component) == false)
   {
      return;
   }
      
   //Mount the weapons
   %weapon = %component.getDatablock().weaponL;
   if(strlen(%weapon) > 0)
   {
      %object.mountImage(%weapon,1);
   }
   %weapon = %component.getDatablock().weaponR;
   if(strlen(%weapon) > 0)
   {
      %object.mountImage(%weapon,2);
   }
   
   // add the disaster alert if it has not yet been added
   // (this occurs when a building becomes under attack)
   %disaster = $DisasterManager.getBanditAttack(%object);
   if (isObject(%disaster) == true)
   {
      alertSvrAddBanditAttack(%object, %object.banditTarget);
   }
}

function AISMN_BanditAttackUntilNearDead::OnExit(%this, %data)
{
   GetThisObject(%data).unmountImage(1);
   GetThisObject(%data).unmountImage(2);

   GetThisObject(%data).playThread(0, "root");
   StopEffect(%object, "combat");
}

//EXIT 0: TARGET DOES NOT EXIST (could have been destroyed)
//EXIT 1: DONE ATTACKING
function AISMN_BanditAttackUntilNearDead::Update(%this, %data)
{
   // this is the bandit object
   %bandit = GetThisObject(%data);
   
   // if someone has started attacking the bandit
   if (%data.isUnderAttack() == true)
   {
      %data.attacker = %data.GetAttackerOf();
      EndAttackLoop(%bandit, false);
      ReturnValue(%data, 1);
      return;
   }
   
   // if the bandit's ally is under attack
   if (%data.allyIsUnderAttack() == true)
   {
      %ally = %data.getAllyUnderAttack();
      %data.attacker = %data.GetAttackerOf(%ally);
      EndAttackLoop(%bandit, false);
      ReturnValue(%data, 1);
      return;
   }
   
	//Is the target dead? If so, abort the state machine.
	%target = %bandit.banditTarget;
	if (IsAlive(%target) == false || %target.health <= %target.banditHealth)
	{
	   EndAttackLoop(%bandit, true);

      %manager = $DisasterManager;
      %disaster = %manager.getBanditAttack(%bandit);
      if (isObject(%disaster) == true)
      {
         %disaster.removeBandit(%bandit);
      }
      
      // remove the disaster alert if it has not yet been removed
      %message = slgGetUIString("id_bandit_attack_over");
      alertSvrRemoveObject($ALERT_BANDIT, %target, %message);
      
		if (IsUnderAttack(%target) == false)
		{
		   slgAIManDisasterStealHappiness(GetThisObject(%data));

         // check if money should be stolen from the bank
         if (%target.banditSteal == true)
         {
            %money = %disaster.steal();
         }
		}
		
		ReturnValue(%data, 0);
		%data.performAction("leave");
		return;
	}
	
   //Stay in this state
   ReturnValue(%data, -1);
}
